﻿<%@ WebService Language="C#" CodeBehind="Tx5xxCO2.asmx.cs" Class="WebSensorWebServiceExamples.Tx5xxCO2" %>

//
// Read SOAP message example for devices with CO2 measurement
//
// Requirements: Tx5xx/Tx6xx device with CO2 measurement and firmware version 1-5-7-4 or higher
//               IIS 7 server
//
//  Purpose of this example is demonstration of communication with Tx5xx/Tx6xx device.
//  It is not intended to be used in production environment without further changes.
//


using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Web;
using System.Web.Services;
using System.Web.Services.Protocols;

namespace WebSensorWebServiceExamples
{
  /// <summary>
  /// Example of collecting SOAP messages from Txxxx CO2 Web Sensor.
  /// Edit constant FILENAME to requested ouptut file location.
  /// </summary>
  [WebService(Namespace = "http://cometsystem.cz/schemas/soapTx5xxCO2.xsd")]
  [SoapDocumentService(RoutingStyle = SoapServiceRoutingStyle.RequestElement)]
  public class Tx5xxCO2 : System.Web.Services.WebService
  {
    public const string FILENAME = @"d:\TxxxxCO2.txt";

    [WebMethod(Description = "Example of processing sample from Txxxx CO2 sensor.")]
    public bool InsertTx5xxCO2Sample(
      string passKey,
      string device,
      string temp,
      string relHum,
      string compQuant,
      string co2,
      string alarms,
      string lev1,
      string lev2,
      string lev3,
      string compType,
      string tempU,
      string timer)
    {
      StringBuilder sb = new StringBuilder();
      sb.AppendLine(string.Format("passKey: {0}", passKey));
      sb.AppendLine(string.Format("device: {0}", device));
      sb.AppendLine(string.Format("temp: {0}", temp));
      sb.AppendLine(string.Format("relHum: {0}", relHum));
      sb.AppendLine(string.Format("compQuant: {0}", compQuant));
      sb.AppendLine(string.Format("co2: {0}", co2));
      sb.AppendLine(string.Format("alarms: {0}", alarms));
      sb.AppendLine(string.Format("lev1: {0}", lev1));
      sb.AppendLine(string.Format("lev2: {0}", lev2));
      sb.AppendLine(string.Format("lev3: {0}", lev3));
      sb.AppendLine(string.Format("compType: {0}", compType));
      sb.AppendLine(string.Format("tempU: {0}", tempU));
      sb.AppendLine(string.Format("timer: {0}", timer));

      if (File.Exists(FILENAME))
        File.Delete(FILENAME);
      File.WriteAllText(FILENAME, sb.ToString());

      return true;
    }
  }
}
