﻿<%@ WebService Language="C#" CodeBehind="Tx5xx.asmx.cs" Class="WebSensorWebServiceExamples.Tx5xx" %>

//
// Read SOAP message example for devices with t+rh+p measurement
//
// Requirements: Tx5xx/Tx6xx device with t+rh+p measurement and firmware version 1-5-7-4 or higher
//               IIS 7 server
//
//  Purpose of this example is demonstration of communication with Tx5xx/Tx6xx device.
//  It is not intended to be used in production environment without further changes.
//


using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Web;
using System.Web.Services;
using System.Web.Services.Protocols;

namespace WebSensorWebServiceExamples
{
  /// <summary>
  /// Example of collecting SOAP messages from Txxxx Web Sensor.
  /// Edit constant FILENAME to requested ouptut file location.
  /// </summary>
  [WebService(Namespace = "http://cometsystem.cz/schemas/soapTx5xx_v2.xsd")]
  [SoapDocumentService(RoutingStyle = SoapServiceRoutingStyle.RequestElement)]
  public class Tx5xx : System.Web.Services.WebService
  {
    public const string FILENAME = @"d:\Txxxx.txt";

    [WebMethod(Description = "Example of processing sample from Txxxx sensor.")]
    public bool InsertTx5xxSample(
      string passKey,
      string device,
      string temp,
      string relHum,
      string compQuant,
      string pressure,
      string alarms,
      string compType,
      string tempU,
      string pressureU,
      string timer)
    {
      StringBuilder sb = new StringBuilder();
      sb.AppendLine(string.Format("passKey: {0}", passKey));
      sb.AppendLine(string.Format("device: {0}", device));
      sb.AppendLine(string.Format("temp: {0}", temp));
      sb.AppendLine(string.Format("relHum: {0}", relHum));
      sb.AppendLine(string.Format("compQuant: {0}", compQuant));
      sb.AppendLine(string.Format("pressure: {0}", pressure));
      sb.AppendLine(string.Format("alarms: {0}", alarms));
      sb.AppendLine(string.Format("compType: {0}", compType));
      sb.AppendLine(string.Format("tempU: {0}", tempU));
      sb.AppendLine(string.Format("pressureU: {0}", pressureU));
      sb.AppendLine(string.Format("timer: {0}", timer));

      if (File.Exists(FILENAME))
        File.Delete(FILENAME);
      File.WriteAllText(FILENAME, sb.ToString());

      return true;
    }
  }
}
