#
# Read current measured values from values.json
#
# Requirements: Python 3.8 ( www.python.org )
#               Wx7xx device with firmware version 10-0-2-0 or higher
#
#  Purpose of this example is demonstration of communication with Wx7xx device(s).
#  It is not intended to be used in production environment without further changes.
#

# connection parameters
DEVICE_IP = '192.168.1.213'

import urllib.request, json

# read JSON file from device
r = urllib.request.urlopen("http://"+DEVICE_IP+"/values.json")
c = r.read(2048)

# decode JSON
j = json.loads(c)

# print values from channels
for ch in j["ch"]:
    if ch["name"]!="":
        print(ch["name"]+": "+ch["value"]+" "+ch["unit"])
