#
# Read current measured values from values.xml
#
# Requirements: Python 3.8 ( www.python.org )
#               Wx7xx device with firmware version 10-0-2-0 or higher
#
#  Purpose of this example is demonstration of communication with Wx7xx device(s).
#  It is not intended to be used in production environment without further changes.
#

# connection parameters
DEVICE_IP = '192.168.1.213'

import urllib.request, sys
import xml.etree.ElementTree as ET

# read XML file from device
r = urllib.request.urlopen("http://"+DEVICE_IP+"/values.xml")
xmldoc = ET.fromstring(r.read(2048))

# values from elements with tags <unit>
for child in xmldoc:
    if child.findall("name") and child[0].text!=None:
        print(child[0].text+":", child[2].text, child[1].text)
